using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

using JacekMatulewski.Reversi;

namespace ReversiAspNet
{
	/// <summary>
	/// Summary description for WebForm1.
	/// </summary>
	public class WebForm1 : System.Web.UI.Page
	{
		//static private ReversiSilnikAI silnik=new ReversiSilnikAI();
		private ReversiSilnikAI silnik=null;
		static int licznik=0;
		private Button[,] plansza=new Button[ReversiSilnikAI.planszaSzer,ReversiSilnikAI.planszaWys];
		private Color[] kolory={Color.Ivory, Color.Green, Color.Sienna};
		protected System.Web.UI.WebControls.Table table1;
		protected System.Web.UI.WebControls.Button button1;
		protected System.Web.UI.WebControls.ListBox listBox1;
		protected System.Web.UI.WebControls.ListBox listBox2;
		protected System.Web.UI.WebControls.Label label5;
		protected System.Web.UI.WebControls.Label label2;
		protected System.Web.UI.WebControls.Label label3;
		protected System.Web.UI.WebControls.Label label6;
		protected System.Web.UI.WebControls.Label labelMessage;
		protected System.Web.UI.WebControls.Label label1;
		protected System.Web.UI.WebControls.Button button2;
		protected System.Web.UI.WebControls.HyperLink hyperLink1;
		protected System.Web.UI.WebControls.Button button3;

		private void Page_Load(object sender, System.EventArgs e)
		{
			licznik++;
			//labelMessage.Text=licznik.ToString();
			if (Session["identyfikator"]!=null)
				labelMessage.Text="Witaj "+(string)Session["identyfikator"]+"!";
				else
				Response.Redirect("Logowanie.aspx");
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);

			inicjujPlansze();
		}

		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.button3.Click += new System.EventHandler(this.button3_Click);
			this.button2.Click += new System.EventHandler(this.button2_Click);
			this.button1.Click += new System.EventHandler(this.button1_Click);
			this.Load += new System.EventHandler(this.Page_Load);
		}
		#endregion

		#region Metody pomocnicze
		private void inicjujPlansze()
		{
			//Odczytanie obiektu ReversiSilnikAI
			silnik=(ReversiSilnikAI)Session["silnik"];

			//Pobranie wersji aplikacji
			System.Reflection.Assembly a=System.Reflection.Assembly.GetExecutingAssembly();
			labelMessage.Text="Wersja:  <font color=green>"+a.GetName().Version+"</font>";

			//ustalanie rozmiaru przycisku
			int rozmiarPlanszy=400;
			int przyciskSzer=rozmiarPlanszy/ReversiSilnikAI.planszaSzer;
			int przyciskWys=rozmiarPlanszy/ReversiSilnikAI.planszaWys;

			//przygotowywanie tabeli z przyciskami
			TableRow[] wiersze=new TableRow[ReversiSilnikAI.planszaWys];
			for (int j=0; j<ReversiSilnikAI.planszaWys; j++)
				{
				wiersze[j]=new TableRow();
				table1.Rows.Add(wiersze[j]);
				for (int i=0; i<ReversiSilnikAI.planszaSzer; i++)
					{
					TableCell komorka=new TableCell();
					wiersze[j].Cells.Add(komorka);
					Button pole=new Button();

					pole.Width=przyciskSzer;
					pole.Height=przyciskWys;

					pole.Click+=new System.EventHandler(this.kliknieciePolaPlanszy);

					komorka.Controls.Add(pole);
					plansza[i,j]=pole;
					}
				}

				uzgodnijWygladPlanszy();
		}

		private void uzgodnijWygladPlanszy()
		{
			for (int i=0; i<ReversiSilnikAI.planszaSzer; i++)
				for (int j=0; j<ReversiSilnikAI.planszaWys; j++)
					{
					plansza[i,j].BackColor=kolory[silnik[i,j]];
					//plansza[i,j].Text=silnik[i,j].ToString();
					}

			//this.Text="Nastpny ruch gracz nr "+silnik.NumerGraczaWykonujacegoNastepnyRuch();
			button1.BackColor=kolory[silnik.NumerGraczaWykonujacegoNastepnyRuch()];
		}

		void kliknieciePolaPlanszy(object sender,EventArgs e)
		{
			//szukamy odpowiedniego pola planszy
			int kliknietePoziomo=-1,kliknietePionowo=-1;
			for(int poziomo=0;poziomo<ReversiSilnikAI.planszaSzer;poziomo++)
				for(int pionowo=0;pionowo<ReversiSilnikAI.planszaWys;pionowo++)
					if (sender==plansza[poziomo,pionowo])
						{
						kliknietePoziomo=poziomo;
						kliknietePionowo=pionowo;
						}

			//labelMessage.Text="Gracz "+silnik.NumerGraczaWykonujacegoNastepnyRuch().ToString()+" wybra pole "+kliknietePoziomo+", "+kliknietePionowo+".";

			//jezeli nie znaleziony - zglaszanie bledu
			if (kliknietePoziomo==-1 || kliknietePionowo==-1)
				throw new Exception("Nie zidentyfikowane pole planszy");

			//wykonanie ruchu
			int zapamietanyNumerGracza=silnik.NumerGraczaWykonujacegoNastepnyRuch();
			if (silnik.UstawPionek(kliknietePoziomo,kliknietePionowo))
				{
				uzgodnijWygladPlanszy();
				//listBox1.Items.Add(""+zapamietanyNumerGracza+": "+kliknietePoziomo+", "+kliknietePionowo);
				switch(zapamietanyNumerGracza)
					{
					case 1: listBox1.Items.Add(ReversiSilnikAI.SymbolPola(kliknietePoziomo,kliknietePionowo)); break;
					case 2: listBox2.Items.Add(ReversiSilnikAI.SymbolPola(kliknietePoziomo,kliknietePionowo)); break;
					}
				listBox1.SelectedIndex=listBox1.Items.Count-1;
				listBox2.SelectedIndex=listBox2.Items.Count-1;
				}

			//sprawdzenie czy gra skonczona
			int[] zliczenia=new int[3];
			int koniec_kod=silnik.CzyKoniec(zliczenia);
			label5.Text=zliczenia[1].ToString();
			label6.Text=zliczenia[2].ToString();
			if (koniec_kod==2) labelMessage.Text="Uwaga! <FONT COLOR=green>Obaj gracze nie mog wykona ruchu</FONT>";
			if (koniec_kod>0)
				{
				//informacja o wygranym
				labelMessage.Text="Wygra gracz "+((zliczenia[1]>zliczenia[2])?"zielony!":"brzowy!");
				table1.Visible=false;
				button2.Visible=true;
				return;
				}

			//sprawdzenie czy kolejny gracz ma mozliwosc ruchu
			if (!silnik.CzyMozliwyRuch())
				{
				labelMessage.Text="Uwaga! <FONT COLOR=green>Gracz "+((silnik.NumerGraczaWykonujacegoNastepnyRuch()==1)?"zielony":"brzowy")+" zmuszony jest do oddania ruchu</FONT>";
				silnik.Pass();
				uzgodnijWygladPlanszy();
				}
		}
		#endregion
		
		private void button1_Click(object sender, System.EventArgs e)
		{
			int[] wspolrzedne=silnik.ProponujNajlepszyRuch();
			kliknieciePolaPlanszy(plansza[wspolrzedne[0],wspolrzedne[1]],e);
		}
		
		private void button2_Click(object sender, System.EventArgs e)
		{
			//rozpoczecie gry od nowa
			silnik=new ReversiSilnikAI(); //stary obiekt zostanie automatycznie usuniety
			Session.Add("silnik",silnik);
			listBox1.Items.Clear();
			listBox2.Items.Clear();
			label5.Text="2";
			label6.Text="2";
			uzgodnijWygladPlanszy();

			button2.Visible=false;
			table1.Visible=true;
		}

		private void button3_Click(object sender, System.EventArgs e)
		{
			ArrayList listaOsobZalogowanych=(ArrayList)Application["listaOsobZalogowanych"];
			listaOsobZalogowanych.Remove((string)Session["identyfikator"]);
			Session.Remove("identyfikator");
			Response.Redirect("Reversi.aspx");
		}
	}
}

/*
W grze Reversi gracze zajmuj na przemian pola planszy przejmujc przy tym wszystkie pola przeciwnika znajdujce si midzy nowo zajtym polem, a innymi polami gracza wykonujcego ruch. Celem gry jest zdobycie wikszej iloci pl ni przeciwnik.
Gracz moe zaj jedynie takie pole, ktre pozwoli mu przej przynajmniej jedno pole przeciwnika. Jeeli takiego pola nie ma, musi odda ruch.
Gra koczy si w momencie zajcia wszystkich pl lub gdy aden z graczy nie moe wykona ruchu.
*/